#cs ----------------------------------------------------------------------------

 Remmanaut, the autoit RMM tool

 Script function:		Transfer connector, handles file transfers
 Version:				0.2.3

 Author:				Faldo / Erik Ribbhammar
 UDF Credits:			lod3n (_RunReadStd), dantay9 (TCP File Transfer),
						Prog@ndy (MySQL, _TCPconnect), Greg Laabs (_http)
 Helping Credits:

#ce ----------------------------------------------------------------------------
#NoTrayIcon
#include <File.au3>
#include <Array.au3>

;Predefined variables
Global $ListenIP = "0.0.0.0"
Global $FilePort = IniRead ( "settings.ini", "variables", "FilePort", "5074" )
Global $FileDir_In = @ScriptDir&"\file_in"
Global $FileDir_Out = @ScriptDir&"\file_out"

;Listen for incomming TCP connections
TCPStartup()
$Listen = TCPListen($ListenIP, $FilePort)
If @error Or $Listen = '-1' Then
	Exit _FileWriteLog(@ScriptDir & "\log.txt", "Unable to start transfer connector, exiting...")
Else
	_FileWriteLog(@ScriptDir & "\log.txt", "Transfer connector listening on port "&$FilePort)
EndIf

While 1
	;Seq1: Wait for agent to create a session, reply "Ready"
	Do
		$FileSocket = TCPAccept($Listen)
		Sleep('100')
	Until $FileSocket <> -1
	TCPSend($FileSocket, "Ready")

	;Seq2: Wait for transfer direction and file data
	For $i = 1 to 10
		$Receive = TCPRecv($FileSocket, 1000)
		Sleep('100')
		If $Receive <> "" then ExitLoop
	Next

	$FileDataArray = StringSplit($Receive, "|")
	$TransferDirection = $FileDataArray[1]

	If $TransferDirection = "from_agent" then
		Download()
	ElseIf $TransferDirection = "to_agent" then
		Upload()
	EndIf

WEnd


Func Download()
	$FileName = $FileDataArray[2]

	$FilePath = $FileDir_In &"\" & $FileName ;Define serverpath and filename
	$FileHandle = FileOpen($FilePath, 16 + 2 + 8) ;Open serverfile for binary writing

	$bEOF = Binary(@CRLF & "{EOF}") ;Binary code for the end of the file
	$iEOFLen = BinaryLen($bEOF) ;Length of the binary code
	$bData = Binary("") ;Empty binary data which will contain the binary data of the file
	$iDataLen = 0 ;Store the length of the data received
	$bEOFReached = False ;End of file bool

	;Seq3: Initiate transfer by sending "Start upload"
	TCPSend($FileSocket, "Start Upload")

	;Seq4/5: Loop receive file as binary until "end of file" is recieved
	_FileWriteLog(@ScriptDir & "\log.txt", 'Receiving file '&$FileName&' and storing it in '&$FileDir_In)
	Do
		$bData = TCPRecv($FileSocket, 4096, 1)

		$iDataLen = BinaryLen($bData)

		; If nothing is received, retry for the incoming data.
		If $iDataLen = 0 Then ContinueLoop

		; If the end of the file is reached.
		If BinaryMid($bData, 1 + $iDataLen - $iEOFLen, $iEOFLen) = $bEOF Then
			; Strip the EOF code from the file data.
			$bData = BinaryMid($bData, 1, $iDataLen - $iEOFLen)

			; Set the EOFReached to True.
			$bEOFReached = True
		EndIf

		FileWrite($FileHandle, $bData)
	Until $bEOFReached
	_FileWriteLog(@ScriptDir & "\log.txt", 'File received successfully!')

	FileClose($FileHandle)
	TCPCloseSocket($FileSocket)
EndFunc

Func Upload()
	$server_filename = $FileDataArray[2]
	$ServerFile = $FileDir_Out&"\"&$server_filename

	;Get file size
	$iFileSize = FileGetSize($ServerFile)

	;Get file name
	$Reg = StringRegExp($ServerFile, "(.)+\\((.)+)?", 3)
	ConsoleWrite($Reg & @CRLF)
	Select
		Case Not IsArray($Reg)
			$Name = $Reg
		Case UBound($Reg) < 2
				Return SetError(2, 0, -1)
		Case Else
			$Name = $Reg[1]
	EndSelect

	;Seq3: Send Name and file size to client
	sleep(100)
	TCPSend($FileSocket, $Name & "|" & $iFileSize)

	;Open file to read from in binary mode
	$FileHandle = FileOpen($ServerFile, 16)

	;Seq4: Initiate transfer by sending "Start Download"
	sleep(100)
	TCPSend($FileSocket, "Start Download")

	;Seq5: Loop sending file in chunks as binary until size exceeds offset
	Local $BytesRead = 0
	Local $iOffset = 0
	_FileWriteLog(@ScriptDir & "\log.txt", 'Sending file '&$ServerFile&' to agent')
	Do
		FileSetPos($FileHandle, $iOffset, $FILE_BEGIN)
		$BytesRead += TCPSend($FileSocket, FileRead($FileHandle, 4096))

		;Calculate percentage for bytes sent of total size
;~ 		Round($BytesRead / $iFileSize * 100) ;For use in GUI

		$iOffset += 4096
	Until $iOffset >= $iFileSize
	;Seq6: Send "End of file" to finish transfer')
	TCPSend($FileSocket, @CRLF & "{EOF}")

	_FileWriteLog(@ScriptDir & "\log.txt", 'File sent successfully!')
	FileClose($FileHandle)
	TCPCloseSocket($FileSocket)
EndFunc